<?php

namespace App\Http\Controllers\Therapists;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Podcast;
use App\Http\Requests\Therapists\TherapistPodcasts\CreateRequest;
use App\Http\Resources\Web\PodcastsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistPodcastsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist');
      // $this->middleware('permission:therapist_podcasts.index');
      // $this->middleware('permission:therapist_podcasts.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_podcasts.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_podcasts.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_podcasts.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_podcasts.import',['only' => ['import']])
      // $this->middleware('permission:therapist_podcasts.update|therapist_podcasts.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_podcasts =  $therapist->therapist_podcasts()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_podcasts =  $therapist_podcasts->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_podcasts =  $therapist_podcasts->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_podcasts = $therapist_podcasts->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_podcasts = $therapist_podcasts->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_podcasts = $therapist_podcasts->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_podcasts = $therapist_podcasts->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_podcasts = $therapist_podcasts->get();
        return $therapist_podcasts;
      }
      $totalTherapistPodcasts = $therapist_podcasts->count();
      $therapist_podcasts = $therapist_podcasts->paginate($req->perPage);
      $therapist_podcasts = PodcastsResource::collection($therapist_podcasts)->response()->getData(true);

      return $therapist_podcasts;
    }
    $therapist_podcasts = PodcastsResource::collection($therapist->therapist_podcasts()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_podcasts;
  }

  /********* FETCH ALL TherapistPodcasts ***********/
    public function index()
    {
        $therapist_podcasts =  $this->getter();
        $response = generateResponse($therapist_podcasts,count($therapist_podcasts['data']) > 0 ? true:false,'TherapistPodcasts Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistPodcasts FOR Search ***********/
   public function filter(Request $request){
     $therapist_podcasts = $this->getter($request);
     $response = generateResponse($therapist_podcasts,count($therapist_podcasts['data']) > 0 ? true:false,'Filter TherapistPodcasts Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistPodcast ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_podcasts');
      $data['audio'] = uploadFile($request,'audio','therapist_podcasts');
      $data['video'] = uploadFile($request,'video','therapist_podcasts');
      $therapist_podcast = $therapist->therapist_podcasts()->create($data);
      $therapist_podcast->slug = Str::slug($therapist_podcast->name . ' ' . $therapist_podcast->id, '-');
      $therapist_podcast->save();
      $therapist_podcast = $therapist->therapist_podcasts()->withAll()->find($therapist_podcast->id);
      $therapist_podcast = new PodcastsResource($therapist_podcast);
      $therapist_podcast->tags()->sync($request->tag_ids);
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_podcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_podcast = $therapist->therapist_podcasts()->withAll()->find($therapist_podcast);
        if($therapist_podcast){
          $therapist_podcast = new PodcastsResource($therapist_podcast);
          $response = generateResponse($therapist_podcast,true,'TherapistPodcast Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistPodcast Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistPodcast ***********/
    public function update(CreateRequest $request, Podcast $therapist_podcast)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_podcasts',$therapist_podcast->image);
        } else {
            $data['image'] = $therapist_podcast->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_podcasts');
        } else {
            $data['audio'] = $therapist_podcast->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_podcasts');
        } else {
            $data['video'] = $therapist_podcast->video;
        }
        $therapist_podcast->update($data);
        $therapist_podcast = $therapist_podcast->find($therapist_podcast->id);
        $slug = Str::slug($therapist_podcast['name'] . ' ' . $therapist_podcast->id, '-');
        $therapist_podcast->update(
            [
                'slug' => $slug
            ]
        );
        $therapist_podcast->tags()->sync($request->tag_ids);
        DB::commit();
      }
        catch (\Exception $e) {
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistPodcast Status***********/
    public function updateStatus(Request $request,Podcast $therapist_podcast){
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_podcast->update([
          'is_active' => $therapist_podcast->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistPodcast Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistPodcast ***********/
    public function destroy(Request $request,Podcast $therapist_podcast)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_podcast->therapist_id != $therapist->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_podcast->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_podcast->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistPodcast ***********/
    public function destroyPermanently(Request $request,$therapist_podcast)
    {
        $therapist= auth()->user()->therapist;
        $therapist_podcast = $therapist->therapist_podcasts()->withTrashed()->find($therapist_podcast);
        if($therapist_podcast){
            if($therapist_podcast->therapist_id != $therapist->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_podcast->trashed()) {
            $therapist_podcast->forceDelete();
            $response = generateResponse(null,true,'TherapistPodcast Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPodcast is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistPodcast not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistPodcast ***********/
    public function restore(Request $request,$therapist_podcast)
    {
      $therapist= auth()->user()->therapist;
      $therapist_podcast = $therapist->therapist_podcasts()->withTrashed()->find($therapist_podcast);
          if ($therapist_podcast->trashed()) {
            $therapist_podcast->restore();
            $response = generateResponse(null,true,'TherapistPodcast Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistPodcast is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
